; Inno Setup Script for Automation Recorder
; Download Inno Setup from: https://jrsoftware.org/isdl.php

[Setup]
AppName=Automation Recorder
AppVersion=1.0
AppPublisher=Harava
AppPublisherURL=https://github.com/kriba95/AutomationRecorder
DefaultDirName={autopf}\AutomationRecorder
DefaultGroupName=Automation Recorder
OutputDir=installer_output
OutputBaseFilename=AutomationRecorder_Setup
Compression=lzma2
SolidCompression=yes
WizardStyle=modern
; Uncomment the following line to disable "This app is not commonly downloaded" warning
; Reduces warnings slightly but doesn't eliminate them without code signing
PrivilegesRequired=admin

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"

[Files]
Source: "dist\AutomationRecorder.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "BUILD_INSTRUCTIONS.md"; DestDir: "{app}"; Flags: ignoreversion
Source: "licence"; DestDir: "{app}"; Flags: ignoreversion; DestName: "LICENSE.txt"

[Icons]
Name: "{group}\Automation Recorder"; Filename: "{app}\AutomationRecorder.exe"
Name: "{group}\Uninstall Automation Recorder"; Filename: "{uninstallexe}"
Name: "{autodesktop}\Automation Recorder"; Filename: "{app}\AutomationRecorder.exe"; Tasks: desktopicon

[Run]
Filename: "{app}\AutomationRecorder.exe"; Description: "{cm:LaunchProgram,Automation Recorder}"; Flags: nowait postinstall skipifsilent
